

capture log close

cd "U:\Hemmeter\SBST"
set more off
set logtype text
set seed 1234567890

log using "SSI Letters Figures Month 24 $S_DATE", replace

/*Figure 1*/
use coef_fig1p, clear

generate str group = ""
replace group = "Control" in 1
replace group = "Control" in 2
replace group = "Any" in 3
replace group = "Any" in 4
replace group = "Basic" in 5
replace group = "Basic" in 6
replace group = "Simple" in 7
replace group = "Simple" in 8
replace group = "Maximum" in 9
replace group = "Maximum" in 10
replace group = "Combined" in 11
replace group = "Combined" in 12


generate str event = ""
replace event = "Applied" in 1
replace event = "Awarded" in 2
replace event = "Applied" in 3
replace event = "Awarded" in 4
replace event = "Applied" in 5
replace event = "Awarded" in 6
replace event = "Applied" in 7
replace event = "Awarded" in 8
replace event = "Applied" in 9
replace event = "Awarded" in 10
replace event = "Applied" in 11
replace event = "Awarded" in 12

capture drop barorder
gen barorder=1 if group=="Control"
replace barorder=2 if group=="Control" & event=="Awarded"
replace barorder=4 if group=="Any"
replace barorder=5 if group=="Any" & event=="Awarded"
replace barorder=7 if group=="Basic"
replace barorder=8 if group=="Basic" & event=="Awarded"
replace barorder=10 if group=="Simple"
replace barorder=11 if group=="Simple" & event=="Awarded"
replace barorder=13 if group=="Maximum"
replace barorder=14 if group=="Maximum" & event=="Awarded"
replace barorder=16 if group=="Combined"
replace barorder=17 if group=="Combined" & event=="Awarded"

gen outcome=1 if event=="Applied"
replace outcome=2 if event=="Awarded"

replace Estimate=100*Estimate
replace Low=100*Low
replace High=100*High


gen Estimate_rounded = strofreal(Estimate, "%03.2f")

twoway (bar Estimate barorder if outcome==1, color(gs1) ) ///
             (bar Estimate barorder if outcome==2, color(gs10) ) ///
             (rcap High Low barorder, color(black))  ///
             (scatter Estimate barorder, ms(none) mlabel(Estimate_rounded) mlabcolor(black) mlabsize(small) mlabposition(1 legend(off))), ///
             legend( row(1) order(1 "Applied" 2 "Awarded" 3 "95% CI") ) ///
             title("Figure 1: Applications and Awards at 24 Month Follow-Up") ///
             xlabel( 1.5 "None" 4.5 "Any" 7.5 "Basic" 10.5 "Maximum" 13.5 "Simple" 16.5 "Combined", noticks) ///
             note("Note: Authors' calculations using Social Secruity Administration data.") ///
             ytitle("Percent") xtitle("Letter Type") 


graph save figure1.gph, replace
graph save figure1.png, replace



/*Figure 2*/
use coef_fig2p, clear
rename _rowname group

capture drop barorder
gen barorder=1 if group=="Control"
replace barorder=3 if group=="Any"
replace barorder=5 if group=="Basic"
replace barorder=7 if group=="Simple"
replace barorder=9 if group=="Maximum"
replace barorder=11 if group=="Combined"

gen Estimate_rounded = strofreal(Estimate, "%03.0f")

twoway (bar Estimate barorder, color(gs1)) ///
	   (rcap High Low barorder, color(black)) ///
	   (scatter Estimate barorder, ms(none) mlabel(Estimate_rounded) mlabcolor(black) mlabsize(small) mlabposition(1 legend(off))), ///
		legend( row(1) order(1 "Benefit" 2 "95% CI") ) ///
		title("Figure 2: Award Amount at 24 Month Follow-Up," "Conditional on Receiving SSI") ///
		xlabel( 1 "None" 3 "Any" 5 "Basic" 7 "Maximum" 9 "Simple" 11 "Combined", noticks) ///
		ylabel( 50 100 150 200 250) ///
		note("Note: Authors' calculations using Social Secruity Administration data.") ///
		ytitle("Average monthly benefit ($)") xtitle("Letter Type")

graph save figure2.gph, replace
graph save figure2.png, replace


/*Figure 3*/
use coef_fig3p, clear
rename _rowname month
destring month, replace

replace AppT=AppT*100
replace AppC=AppC*100
replace AwdT=AwdT*100
replace AwdC=AwdC*100

twoway  (line AppT month, color(gs1) lp(solid) mlabel(AppT)) ///
		(line AppC month, color(gs10) lp(solid) mlabel(AppC)) ///
		(line AwdT month, color(gs1) lp(dash) mlabel(AwdT)) ///
		(line AwdC month, color(gs10) lp(dash) mlabel(AwdC)) , ///
		legend( row(2) order(1 "Any letter (Application)" 2 "No letter (Application)" ///
			3 "Any letter (Award)" 4 "No letter (Award)") ) ///
		title("Figure 3: Dynamic Effects of Receiving Any Letter") ///
		xlabel( 3 "3" 6 "6" 9 "9" 12 "12" 15 "15" 18 "18" 21 "21" 24 "24", noticks)	///
		ylabel( 2 4 6 8) ///
		note("Note: Authors' calculations using Social Secruity Administration data.") ///
		ytitle("Percent") xtitle("Month")
			
graph save figure3.gph, replace
graph save figure3.png, replace

log close